/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.apps.designer.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMWorkflowListCellRenderer;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class VWSIMWorkflowSelectionDialog
extends VWModalDialog
implements IVWDialogButtonsActionListener,
ActionListener {
    protected VWSIMPropertyData m_propertyData = null;
    protected VWWorkflowCollectionDefinition m_wflCollection = null;
    protected VWAddRemovePanel m_wflSelectionPanel = null;
    protected VWDialogButtons m_dlgButtons = null;
    protected JCheckBox m_replaceInitFieldValuesChkBox = null;

    public VWSIMWorkflowSelectionDialog(VWSIMPropertyData propertyData, VWWorkflowCollectionDefinition wflCollection) {
        super(propertyData.getParentFrame());
        this.m_propertyData = propertyData;
        this.m_wflCollection = wflCollection;
        this.setTitle(VWSIMResource.s_importWorkflow);
        Dimension dim = VWStringUtils.stringToDimension("665,335");
        if (dim != null) {
            this.setSize(dim);
        } else {
            this.setSize(600, 300);
        }
        this.createControls();
        this.initializeWorkflowList();
    }

    public VWWorkflowDefinition[] getWorkflowDefinitions() {
        VWWorkflowDefinition[] selectedWflDefs = null;
        Object[] selectedObjects = this.m_wflSelectionPanel.getSelectedItems();
        if (selectedObjects != null && selectedObjects.length > 0) {
            selectedWflDefs = new VWWorkflowDefinition[selectedObjects.length];
            for (int nIndex = 0; nIndex < selectedObjects.length; ++nIndex) {
                VWWorkflowDefinition tmpWflDef = (VWWorkflowDefinition)selectedObjects[nIndex];
                selectedWflDefs[nIndex] = (VWWorkflowDefinition)tmpWflDef.clone();
                try {
                    selectedWflDefs[nIndex].setName(tmpWflDef.getName());
                    continue;
                }
                catch (VWException ex) {
                    // empty catch block
                }
            }
        }
        return selectedWflDefs;
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        switch (event.getID()) {
            case 1: {
                this.performOKAction();
                break;
            }
            case 2: {
                this.performCancelAction();
                break;
            }
            case 32: {
                this.performHelpAction();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_replaceInitFieldValuesChkBox) && this.m_replaceInitFieldValuesChkBox != null) {
            this.m_propertyData.setReplaceInitialDataFields(this.m_replaceInitFieldValuesChkBox.isSelected());
        }
    }

    protected void createControls() {
        try {
            this.getContentPane().setLayout(new BorderLayout(5, 5));
            this.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.m_dlgButtons = new VWDialogButtons(35);
            this.m_dlgButtons.addDialogButtonsActionListener(this);
            this.getContentPane().add((Component)this.m_dlgButtons, "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getMainPanel() {
        try {
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_wflSelectionPanel = new VWAddRemovePanel(3850);
            this.m_wflSelectionPanel.setListCellRenderer(new VWSIMWorkflowListCellRenderer());
            mainPanel.add((Component)this.m_wflSelectionPanel, "Center");
            this.m_replaceInitFieldValuesChkBox = new JCheckBox(VWSIMResource.s_replaceInitialDataFields, false);
            this.m_replaceInitFieldValuesChkBox.addActionListener(this);
            mainPanel.add((Component)this.m_replaceInitFieldValuesChkBox, "Last");
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void performOKAction() {
        this.m_nExitStatus = 0;
        this.setVisible(false);
        if (this.m_replaceInitFieldValuesChkBox != null) {
            this.m_propertyData.setReplaceInitialDataFields(this.m_replaceInitFieldValuesChkBox.isSelected());
        }
    }

    protected void performCancelAction() {
        this.m_nExitStatus = 1;
        this.setVisible(false);
    }

    protected void performHelpAction() {
        VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Designer + "vwsimworkflowselectiondialog.htm");
    }

    private void initializeWorkflowList() {
        try {
            Object[] availableWflDefs = this.m_wflCollection.getWorkflows();
            this.m_wflSelectionPanel.initializeLists(availableWflDefs, null);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }
}

